<?php
include_once 'config.php';

function recursiveRemove($dir) {
    if (is_file($dir)){
        unlink($dir);
        return;
    }

    $structure = glob(rtrim($dir, "/").'/*');
    if (is_array($structure)) {
        foreach($structure as $file) {
            if (is_dir($file)) recursiveRemove($file);
            elseif (is_file($file)) unlink($file);
        }
    }
    rmdir($dir);
}

foreach($config->remove as $target){
    if(file_exists(MY_DIR . $target)){
        recursiveRemove(MY_DIR . $target);
    }
}
foreach($config->pro_widgets as $target){
    $ftarget = MY_DIR . 'widgets/' . $target . '/' . $target . '.php';
    if(file_exists($ftarget)){
        recursiveRemove($ftarget);
    }
}
echo 'removing junk files & directories...OK';
echo "\n";
echo 'removing pro widgets...OK';
echo "\n";