( function ($, elementor) {
    "use strict";

    var ElementsKit_WidgetArea = {
        init: function () {
            elementor.hooks.addAction('frontend/element_ready/global', function ($scope) {
                var editorButton = $scope.find('.widgetarea_warper_edit');
                editorButton.on('click', function() {
                    var iframeParent = window.parent.$('#widgetarea-control-iframe'), 
                    modalContainer = window.parent.$('#elementor-template-library-modal'),
                    content_key = $(this).parent().attr('data-elementskit-widgetarea-key'),
                    index = $(this).parent().attr('data-elementskit-widgetarea-index'),
                    url = window.elementskit.resturl + 'dynamic-content/content_editor/widget/' + content_key + '-' + index;

                    window.parent.$('body').attr('data-elementskit-widgetarea-key', content_key);
                    window.parent.$('body').attr('data-elementskit-widgetarea-load', 'false');
                    
                    modalContainer.css('display', 'block');
                    window.parent.$('.widgetarea_iframe_modal').css('display', 'block');
                    window.parent.$('.dialog-lightbox-loading').css('display', 'block');
                    iframeParent.contents().find('#elementor-loading').css('display', 'block');
                    iframeParent.css('z-index', '-1');
                    iframeParent.attr('src', url);

                    iframeParent.on('load', function() {
                        window.parent.$('.dialog-lightbox-loading').css('display', 'none');
                        iframeParent.css('display', 'block');
                        iframeParent.contents().find('#elementor-loading').css('display', 'none');
                        iframeParent.css('z-index', '1');
                    })
                });
                
                if(typeof window.parent.$ != 'undefined'){
                    var iframeCloseButton = window.parent.$('#elementor-template-library-modal').find('.eicon-close');
                    iframeCloseButton.on('click', function() {
                        window.parent.$('body').attr('data-elementskit-widgetarea-load', 'true');
                    });
                }

            });
        },
    };

    $(window).on('elementor/frontend/init', ElementsKit_WidgetArea.init);

}(jQuery, window.elementorFrontend) );