<?php if (!defined('ABSPATH')) die('Direct access forbidden.');
/**
 * customizer option: banner
 */

 
$options = [
    'banner_setting' => [
        'title' => esc_html__('Banner settings', 'instive'),

        'options' => [
            'sub_page_banner_overlay_style' => [
                'type'  => 'rgba-color-picker',
                'value' => 'rgba(0, 0, 0, 0.4)',
                'attr'  => array( 'class' => 'custom-class', 'data-foo' => 'bar' ),
                // palette colors array
                'palettes' => array( '#ba4e4e', '#0ce9ed', '#941940' ),
                'label' => esc_html__('Banner Overlay Color', 'instive'),
            ],
            'page_banner_setting' => [
                'type'        => 'popup',
                'label'       => esc_html__('Page banner settings', 'instive'),
                'popup-title' => esc_html__('Page banner settings', 'instive'),
                'button'      => esc_html__('Edit page Banner Button', 'instive'),
                'size'        => 'medium', // small, medium, large
                'popup-options' => [
                    'page_show_banner' => [
                        'type'			 => 'switch',
                        'label'			 => esc_html__( 'Show banner?', 'instive' ),
                        'desc'          =>  esc_html__('Show or hide the banner', 'instive'),
                        'value'         => 'yes',
                        'left-choice'	 => [
                            'value'	 => 'yes',
                            'label'	 => esc_html__( 'Yes', 'instive' ),
                        ],
                        'right-choice'	 => [
                            'value'	 => 'no',
                            'label'	 => esc_html__( 'No', 'instive' ),
                        ],
                    ],
                    'page_show_breadcrumb' => [
                        'type'			 => 'switch',
                        'label'			 => esc_html__( 'Show Breadcrumb?', 'instive' ),
                        'desc'          => esc_html__('Show or hide the Breadcrumb', 'instive'),
                        'value'         => 'no',
                        'left-choice'	 => [
                            'value'	 => 'yes',
                            'label'	 => esc_html__( 'Yes', 'instive' ),
                        ],
                        'right-choice'	 => [
                            'value'	 => 'no',
                            'label'	 => esc_html__( 'No', 'instive' ),
                        ],
                    ],
                    'page_title_disable' => [
                        'type'			 => 'switch',
                        'label'			 => esc_html__( 'Disable Page Title', 'instive' ),
                        'value'         => 'no',
                        'left-choice'	 => [
                            'value'	 => 'yes',
                            'label'	 => esc_html__( 'Yes', 'instive' ),
                        ],
                        'right-choice'	 => [
                            'value'	 => 'no',
                            'label'	 => esc_html__( 'NO', 'instive' ),
                        ],
                    ],

                    'banner_page_title'	 => [
                        'type'	 => 'text',
                        'label'	 => esc_html__( 'Banner title', 'instive' ),
                        'value'  => '',
                    ],

                    'banner_page_image'	 =>array(
                        'label'			 => esc_html__( 'Banner image', 'instive' ),
                        'type'			 => 'upload',
                        'images_only'	 => true,
                        'files_ext'		 => array( 'jpg', 'png', 'jpeg', 'gif', 'svg' ),
                              
                        )

                ],
            ], 
        
            'blog_banner_setting' => [
                'type'         => 'popup',
                'label'        => esc_html__('Blog banner settings', 'instive'),
                'popup-title'  => esc_html__('Blog banner settings', 'instive'),
                'button'       => esc_html__('Edit Blog Banner Button', 'instive'),
                'size'         => 'medium', // small, medium, large
                'popup-options' => [
                    'blog_show_banner' => [
                        'type'			 => 'switch',
                        'label'			 => esc_html__( 'Show banner?', 'instive' ),
                        'desc'          => esc_html__('Show or hide the banner', 'instive'),
                        'value'         => 'yes',
                        'left-choice'	 => [
                            'value'	 => 'yes',
                            'label'	 => esc_html__( 'Yes', 'instive' ),
                        ],
                        'right-choice'	 => [
                            'value'	 => 'no',
                            'label'	 => esc_html__( 'No', 'instive' ),
                        ],
                    ],
                    'blog_show_breadcrumb' => [
                        'type'			 => 'switch',
                        'label'			 => esc_html__( 'Show Breadcrumb?', 'instive' ),
                        'desc'           => esc_html__('Show or hide the Breadcrumb', 'instive'),
                        'value'          => 'no',
                        'left-choice'	 => [
                            'value'	 => 'yes',
                            'label'	 => esc_html__( 'Yes', 'instive' ),
                        ],
                        'right-choice'	 => [
                            'value'	 => 'no',
                            'label'	 => esc_html__( 'No', 'instive' ),
                        ],
                    ],
                    'page_title_disable' => [
                        'type'			 => 'switch',
                        'label'			 => esc_html__( 'Disable Page Title', 'instive' ),
                        'value'         => 'no',
                        'left-choice'	 => [
                            'value'	 => 'yes',
                            'label'	 => esc_html__( 'Yes', 'instive' ),
                        ],
                        'right-choice'	 => [
                            'value'	 => 'no',
                            'label'	 => esc_html__( 'NO', 'instive' ),
                        ],
                    ],
                    'banner_blog_title'	 => [
                        'type'	 => 'text',
                        'label'	 => esc_html__( 'Banner title', 'instive' ),
                    ],
                   
                    'banner_blog_image'	 =>array(
                        'type'  => 'upload',
                        'label' => esc_html__('Image', 'instive'),
                        'desc'  => esc_html__('Banner blog image', 'instive'),
                        'images_only' => true,
                        'files_ext' => array( 'PNG', 'JPEG', 'JPG','GIF'),
                              
                     
                    )

                ],
            ],
            'insurance_banner_setting' => [
               'type'         => 'popup',
               'label'        => esc_html__('Insurance banner settings', 'instive'),
               'popup-title'  => esc_html__('Insurance banner settings', 'instive'),
               'button'       => esc_html__('Edit Insurance Banner Button', 'instive'),
               'size'         => 'medium', // small, medium, large
               'popup-options' => [
                   'blog_show_banner' => [
                       'type'			 => 'switch',
                       'label'			 => esc_html__( 'Show banner?', 'instive' ),
                       'desc'          => esc_html__('Show or hide the banner', 'instive'),
                       'value'         => 'yes',
                       'left-choice'	 => [
                           'value'	 => 'yes',
                           'label'	 => esc_html__( 'Yes', 'instive' ),
                       ],
                       'right-choice'	 => [
                           'value'	 => 'no',
                           'label'	 => esc_html__( 'No', 'instive' ),
                       ],
                   ],
                   'blog_show_breadcrumb' => [
                       'type'			 => 'switch',
                       'label'			 => esc_html__( 'Show Breadcrumb?', 'instive' ),
                       'desc'          => esc_html__('Show or hide the Breadcrumb', 'instive'),
                       'value'         => 'no',
                       'left-choice'	 => [
                           'value'	 => 'yes',
                           'label'	 => esc_html__( 'Yes', 'instive' ),
                       ],
                       'right-choice'	 => [
                           'value'	 => 'no',
                           'label'	 => esc_html__( 'No', 'instive' ),
                       ],
                   ],
                    'page_title_disable' => [
                        'type'			 => 'switch',
                        'label'			 => esc_html__( 'Disable Page Title', 'instive' ),
                        'value'         => 'no',
                        'left-choice'	 => [
                            'value'	 => 'yes',
                            'label'	 => esc_html__( 'Yes', 'instive' ),
                        ],
                        'right-choice'	 => [
                            'value'	 => 'no',
                            'label'	 => esc_html__( 'NO', 'instive' ),
                        ],
                    ],
                   'banner_blog_title'	 => [
                       'type'	 => 'text',
                       'label'	 => esc_html__( 'Banner title', 'instive' ),
                   ],
                  
                   'banner_blog_image'	 =>array(
                       'type'  => 'upload',
                       'label' => esc_html__('Image', 'instive'),
                       'desc'  => esc_html__('Banner blog image', 'instive'),
                       'images_only' => true,
                       'files_ext' => array( 'PNG', 'JPEG', 'JPG','GIF'),
                             
                    
                   )

               ],
           ],

           'shop_banner_settings' => [
            'type' => 'popup',
            'label' => esc_html__('Shop banner settings', 'instive'),
            'popup-title' => esc_html__('Shop banner settings', 'instive'),
            'button' => esc_html__('Edit shop banner settings', 'instive'),
            'size' => 'small', // small, medium, large
            'popup-options' => array(
                'show' => array(
                    'type'			 => 'switch',
                    'label'			 => esc_html__( 'Show banner?', 'instive' ),
                    'value' => 'yes',
                    'left-choice'	 => array(
                        'value'	 => 'yes',
                        'label'	 => esc_html__( 'Yes', 'instive' ),
                    ),
                    'right-choice'	 => array(
                        'value'	 => 'no',
                        'label'	 => esc_html__( 'No', 'instive' ),
                    ),
                ),
                'show_breadcrumb' => array(
                    'type'			 => 'switch',
                    'label'			 => esc_html__( 'Show breadcrumb?', 'instive' ),
                    'value' => 'yes',
                    'left-choice'	 => array(
                        'value'	 => 'yes',
                        'label'	 => esc_html__( 'Yes', 'instive' ),
                    ),
                    'right-choice'	 => array(
                        'value'	 => 'no',
                        'label'	 => esc_html__( 'No', 'instive' ),
                    ),
                ),
                'title'		 => array(
                    'label'	 => esc_html__( 'Shop Banner title', 'instive' ),
                    'type'	 => 'text',
                ),
                'single_title'		 => array(
                    'label'	 => esc_html__( 'Single Shop Banner title', 'instive' ),
                    'type'	 => 'text',
                ),
                'banner_shop_image'			 => array(
                    'label'			 => esc_html__( 'Banner image', 'instive' ),
                    'type'			 => 'upload',
                    'images_only'	 => true,
                    'files_ext'		 => array( 'jpg', 'png', 'jpeg', 'gif', 'svg' ),
                ),
            ),
         ],

        ],
    ],
];