<?php

if ( ! defined( 'ABSPATH' ) ) exit;

class instive_Shortcode{

	/**
     * Holds the class object.
     *
     * @since 1.0
     *
     */
    public static $_instance;
    

    /**
     * Localize data array
     *
     * @var array
     */
    public $localize_data = array();

	/**
     * Load Construct
     * 
     * @since 1.0
     */

	public function __construct(){
        add_action('elementskit/loaded', [$this, 'init']);
        add_action('elementor/controls/controls_registered', array( $this, 'instive_icon_pack' ), 11 );

    }


	public function init(){

		  add_action('elementor/init', array($this, 'instive_elementor_init'));
        add_action('elementor/widgets/widgets_registered', array($this, 'instive_shortcode_elements'));
        add_action( 'elementor/editor/after_enqueue_styles', array( $this, 'editor_enqueue_styles' ) );
        add_action( 'elementor/frontend/before_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
        add_action( 'elementor/preview/enqueue_styles', array( $this, 'preview_enqueue_scripts' ) );

	}


    /**
     * Enqueue Scripts
     *
     * @return void  
     */ 
    
     public function enqueue_scripts() {
       wp_enqueue_script( 'instive-main-elementor', INSTIVE_JS  . '/elementor.js',array( 'jquery', 'elementor-frontend' ), INSTIVE_VERSION, true );
    }

    /**
     * Enqueue editor styles
     *
     * @return void
     */

    public function editor_enqueue_styles() {

    }

    /**
     * Preview Enqueue Scripts
     *
     * @return void
     */

    public function preview_enqueue_scripts() {}
	/**
     * Elementor Initialization
     *
     * @since 1.0
     *
     */

    public function instive_elementor_init(){
    
        \Elementor\Plugin::$instance->elements_manager->add_category(
            'instive-elements',
            [
                'title' =>esc_html__( 'instive', 'instive' ),
                'icon' => 'fa fa-plug',
            ],
            1
        );
    }

    /**
     * Extend Icon pack core controls.
     *
     * @param  object $controls_manager Controls manager instance.
     * @return void
     */ 

    public function instive_icon_pack( $controls_manager ) {

        require_once INSTIVE_EDITOR_ELEMENTOR. '/controls/icon.php';

        $controls = array(
            $controls_manager::ICON => 'INSTIVE_Icon_Controler',
        );

        foreach ( $controls as $control_id => $class_name ) {
            $controls_manager->unregister_control( $control_id );
            $controls_manager->register_control( $control_id, new $class_name() );
        }

    }
 
    public function instive_shortcode_elements($widgets_manager){

        require_once INSTIVE_EDITOR_ELEMENTOR.'/widgets/main-slider.php';
        $widgets_manager->register_widget_type(new Elementor\Instive_Main_Slider_Widget());
        
        require_once INSTIVE_EDITOR_ELEMENTOR.'/widgets/team.php';
        $widgets_manager->register_widget_type(new Elementor\Instive_Team_Widget());

        require_once INSTIVE_EDITOR_ELEMENTOR.'/widgets/faqaccordion.php';
        $widgets_manager->register_widget_type(new Elementor\Instive_Faq_Accordian_Widget());

        require_once INSTIVE_EDITOR_ELEMENTOR.'/widgets/testimonial.php';
        $widgets_manager->register_widget_type(new Elementor\Instive_Testimonial_Widget());

        require_once INSTIVE_EDITOR_ELEMENTOR.'/widgets/insurance-service.php';
        $widgets_manager->register_widget_type(new Elementor\Instive_Insurance_Widget());

        require_once INSTIVE_EDITOR_ELEMENTOR.'/widgets/slider-posts.php';
        $widgets_manager->register_widget_type(new Elementor\Instive_Slider_Post_Widget());

        require_once INSTIVE_EDITOR_ELEMENTOR.'/widgets/pricing.php';
        $widgets_manager->register_widget_type(new Elementor\Instive_Pricing_Widget());

        require_once INSTIVE_EDITOR_ELEMENTOR.'/widgets/search.php';
        $widgets_manager->register_widget_type(new Elementor\Instive_Search_Widget());

        require_once INSTIVE_EDITOR_ELEMENTOR.'/widgets/insurace-form.php';
        $widgets_manager->register_widget_type(new Elementor\Instive_contact_form_Widget());
       
        require_once INSTIVE_EDITOR_ELEMENTOR.'/widgets/team-slider.php';
        $widgets_manager->register_widget_type(new Elementor\Instive_Team_Slider_Widget());
       
        require_once INSTIVE_EDITOR_ELEMENTOR.'/widgets/content-slider.php';
        $widgets_manager->register_widget_type(new Elementor\Instive_Content_Slider_Widget());

        require_once INSTIVE_EDITOR_ELEMENTOR.'/widgets/back-to-top.php';
        $widgets_manager->register_widget_type(new Elementor\Instive_Back_To_Top_Widget());

        require_once INSTIVE_EDITOR_ELEMENTOR.'/widgets/logo.php';
        $widgets_manager->register_widget_type(new Elementor\Instive_Site_Logo_Widget());

    }
    
	public static function instive_get_instance() {
        if (!isset(self::$_instance)) {
            self::$_instance = new instive_Shortcode();
        }
        return self::$_instance;
    }

}
instive_Shortcode::instive_get_instance();